import {
  GeoShapeGeoStyle,
  StateNode,
  Vec,
  createShapeId
} from "@tldraw/editor";
class Pointing extends StateNode {
  static id = "pointing";
  markId = "";
  onPointerUp = () => {
    this.complete();
  };
  onPointerMove = (info) => {
    if (this.editor.inputs.isDragging) {
      const { originPagePoint } = this.editor.inputs;
      const id = createShapeId();
      this.markId = `creating:${id}`;
      this.editor.mark(this.markId);
      this.editor.createShapes([
        {
          id,
          type: "geo",
          x: originPagePoint.x,
          y: originPagePoint.y,
          props: {
            w: 1,
            h: 1,
            geo: this.editor.getStyleForNextShape(GeoShapeGeoStyle),
            scale: this.editor.user.getIsDynamicResizeMode() ? 1 / this.editor.getZoomLevel() : 1
          }
        }
      ]).select(id).setCurrentTool("select.resizing", {
        ...info,
        target: "selection",
        handle: "bottom_right",
        isCreating: true,
        creationCursorOffset: { x: 1, y: 1 },
        onInteractionEnd: "geo"
      });
    }
  };
  onCancel = () => {
    this.cancel();
  };
  onComplete = () => {
    this.complete();
  };
  onInterrupt = () => {
    this.cancel();
  };
  complete() {
    const { originPagePoint } = this.editor.inputs;
    const id = createShapeId();
    this.markId = `creating:${id}`;
    this.editor.mark(this.markId);
    const scale = this.editor.user.getIsDynamicResizeMode() ? 1 / this.editor.getZoomLevel() : 1;
    const geo = this.editor.getStyleForNextShape(GeoShapeGeoStyle);
    const size = geo === "star" ? { w: 200, h: 190 } : geo === "cloud" ? { w: 300, h: 180 } : { w: 200, h: 200 };
    this.editor.createShapes([
      {
        id,
        type: "geo",
        x: originPagePoint.x,
        y: originPagePoint.y,
        props: {
          geo: this.editor.getStyleForNextShape(GeoShapeGeoStyle),
          scale,
          ...size
        }
      }
    ]);
    const shape = this.editor.getShape(id);
    if (!shape) return;
    const { w, h } = shape.props;
    const delta = new Vec(w / 2, h / 2).mul(scale);
    const parentTransform = this.editor.getShapeParentTransform(shape);
    if (parentTransform) delta.rot(-parentTransform.rotation());
    this.editor.select(id);
    this.editor.updateShape({
      id: shape.id,
      type: "geo",
      x: shape.x - delta.x,
      y: shape.y - delta.y,
      props: {
        geo: this.editor.getStyleForNextShape(GeoShapeGeoStyle),
        w: w * scale,
        h: h * scale
      }
    });
    if (this.editor.getInstanceState().isToolLocked) {
      this.parent.transition("idle");
    } else {
      this.editor.setCurrentTool("select", {});
    }
  }
  cancel() {
    this.parent.transition("idle");
  }
}
export {
  Pointing
};
//# sourceMappingURL=Pointing.mjs.map
